package require autopsf

set filelist [glob *.pdb]
set sortedfilelist [lsort -dictionary $filelist]
foreach file $sortedfilelist {
set filewhext [file rootname $file]
mol new $file
set strmolid [molinfo top]
autopsf -mol $strmolid -top [list top_all35_ethers.rtf]
package require solvate
solvate ${filewhext}_autopsf.psf ${filewhext}_autopsf.pdb -t 10 -o ${filewhext}_autopsf_wb
}