#include <benchmark/benchmark.h>
#include <cstdlib>
#include <vector>
#include <random>

#define SZ (1 << 28)
#define SEED 111

static void binary(benchmark::State &s) {
  int* array = new int[SZ];
  for(int i = 0; i < SZ; i++) array[i] = i;

  std::mt19937 urng(SEED);
  std::uniform_int_distribution<int> dis(0, SZ - 1);
			       
  while (s.KeepRunning()) {
    s.PauseTiming();    
    int low = 0, high = SZ-1, mid;
    int key = dis(urng);
    s.ResumeTiming();
    
    while(low <= high) {
      mid = (low + high)/2;
      if(array[mid] < key) {
	low = mid + 1; 
      } else if(array[mid] == key) {
	break;
      } else if(array[mid] > key) {
	high = mid-1;
      }
    }
    benchmark::DoNotOptimize(mid);
  }
  delete [] array;
}
// Register the benchmark
BENCHMARK(binary);

static void binary_prefetch(benchmark::State &s) {
  int* array = new int[SZ];
  for(int i = 0; i < SZ; i++) array[i] = i;

  std::mt19937 urng(SEED);
  std::uniform_int_distribution<int> dis(0, SZ - 1);
			     
  
  while (s.KeepRunning()) {
    s.PauseTiming();    
    int low = 0, high = SZ-1, mid;
    int key = dis(urng);
    s.ResumeTiming();
    
    while(low <= high) {
      mid = (low + high)/2;
      
      __builtin_prefetch (&array[(mid + 1 + high)/2], 0, 1);
      __builtin_prefetch (&array[(low + mid - 1)/2], 0, 1);
      
      if(array[mid] < key) {
	low = mid + 1; 
      } else if(array[mid] == key) {
	break;
      } else if(array[mid] > key) {
	high = mid-1;
      }
    }
    benchmark::DoNotOptimize(mid);
  }
  delete [] array;
}
// Register the benchmark
BENCHMARK(binary_prefetch);

// Benchmark main functions
BENCHMARK_MAIN();
