#include <omp.h>
#include <cmath>
#include <iostream>

int main() {
    const int num_intervals = 1 << 30; // Total number of intervals
    const double step = 1.0 / num_intervals; // Width of each interval
    double pi = 0.0;

    double start = omp_get_wtime();
#pragma omp parallel num_threads(32)
    {
      double local_sum = 0.0;
      
#pragma omp for
      for (int i = 0; i < num_intervals; ++i) {
	double x = (i + 0.5) * step;
	local_sum += sqrt(1.0 - x * x) * step;
      }
      
#pragma omp atomic
      pi += local_sum;
    }
    pi *= 4.0; // Scale to compute full Pi from quarter-circle integration
    double end = omp_get_wtime();

    std::cout << "Estimated value of Pi: " << pi << " in " << end - start << " secs" << std::endl;

    return 0;
}
