#include <stdio.h>
#include <omp.h>
#include <cmath>

int main() {
    const long num_intervals = 1 << 30;
    double step = 1.0 / num_intervals;
    double pi  = 0.0;

    for(int exec = 0; exec < 10; exec++) { 
      pi = 0;
      double start = omp_get_wtime();
#pragma omp target map(to: num_intervals, step) map(tofrom: pi)
      {
#pragma omp teams distribute parallel for simd reduction(+:pi)
	for (int i = 0; i < num_intervals; ++i) {
	  double x = (i + 0.5) * step;
	  pi += 4.0 / (1.0 + x * x) * step;
	}
      }
      double end = omp_get_wtime();
      printf("PI (approx) = %f\n", pi);
      printf("Time on GPU = %f seconds\n", end - start);
    }
    
    return 0;
}
