#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define N 100000000

int main() {
    // Allocate memory for vectors
    float *A = (float *)malloc(N * sizeof(float));
    float *B = (float *)malloc(N * sizeof(float));
    float *C = (float *)malloc(N * sizeof(float));

    if (!A || !B || !C) {
        printf("Memory allocation failed!\n");
        return -1;
    }

    for(int x = 0; x < 10; x++) {
      for(int i = 0; i < N; i++) {
	A[i] = B[i] = x;
      }
            
      double start = omp_get_wtime();
      // Map data to the device
#pragma omp target map(to: A[0:N], B[0:N]) map(from: C[0:N])
      {
        // Perform vector addition on the device
#pragma omp teams distribute parallel for simd
        for (int i = 0; i < N; i++) {
	  C[i] = A[i] + B[i];
        }
      }
      double end = omp_get_wtime();
      printf("Time on GPU = %f seconds\n", end - start);

      // Verify results
      int errors = 0;
      for (int i = 0; i < N; i++) {
        if (C[i] != A[i] + B[i]) {
	  errors++;
        }
      }
      
      if (errors == 0) {
        printf("Computation completed successfully!\n");
      } else {
        printf("Errors detected in computation: %d\n", errors);
      }
    }

    // Free allocated memory
    free(A);
    free(B);
    free(C);

    return 0;
}
