#include <stdio.h>
#include <stdlib.h>
#include <omp.h>

#define N 100000000

int main() {
    // Allocate memory for vectors
    float *A = (float *)malloc(N * sizeof(float));
    float *B = (float *)malloc(N * sizeof(float));
    float *C = (float *)malloc(N * sizeof(float));

    if (!A || !B || !C) {
        printf("Memory allocation failed!\n");
        return -1;
    }

    for(int i = 0; i < N; i++) {
      A[i] = B[i] = i;
    }
    
#pragma omp target data map(to: A[0:N], B[0:N]) map(from: C[0:N])
    {
      for(int x = 0; x < 10; x++) {
	double start = omp_get_wtime();
#pragma omp target teams distribute parallel for
	for (int i = 0; i < N; i++) {
	  C[i] = A[i] + B[i];
	}
	double end = omp_get_wtime();
	printf("Time on GPU = %f seconds\n", end - start);

#pragma omp target update from(C[0:N])
	
	// Verify results
	int errors = 0;
	for (int i = 0; i < N; i++) {
	  if (C[i] != A[i] + B[i]) {
	    errors++;
	  }
	}
	
	if (errors == 0) {
	  printf("Computation completed successfully!\n");
	} else {
	  printf("Errors detected in computation: %d\n", errors);
	}
      }
    }
    
    // Free allocated memory
    free(A);
    free(B);
    free(C);

    return 0;
}
