#include<iostream>
#include<omp.h>

#define N  100

using namespace std;

int main(int argc, char const *argv[])
{
	double * a = (double*) malloc (N*sizeof(double));

	int nthreads;
	int thread_id;
	int i;

	double sum=0;
	double local_sum=0;
/*
	#pragma omp parallel for
	for(i=0;i<N;i++){
		a[i]=i;
	}
*/
	#pragma omp parallel private(thread_id, i, local_sum)
	{
		nthreads=omp_get_num_threads();
		thread_id = omp_get_thread_num();
		cout<<nthreads<<" "<<thread_id<<" "<<&thread_id<<endl;

		for(i=thread_id*(N/nthreads); i<(thread_id+1)*(N/nthreads); i++){
				a[i]=i;
				local_sum += a[i];
			}
		#pragma omp atomic
		sum += local_sum;
	}
	for(i=0;i<N;i++)
		cout<<a[i]<<" ";

	cout<<endl<<endl<<sum<<endl;
	return 0;
}
